/**
 * @package    JShopping - States of Russian Federation
 * @version    1.1.0
 * @author     Artem Vasilev - webmasterskaya.xyz
 * @copyright  Copyright (c) 2020 Webmasterskaya. All rights reserved.
 * @license    GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link       https://webmasterskaya.xyz/
 */

create table if not exists `#__jshopping_states`
(
    `state_id`      int(11)      not null auto_increment,
    `country_id`    int(11)      not null,
    `state_publish` tinyint(4)   not null,
    `ordering`      smallint(6)  not null,
    `name_en-GB`    varchar(255) not null,
    `name_de-DE`    varchar(255) not null,
    `name_ru-RU`    varchar(255) not null,
    primary key (`state_id`)
);

delete from `#__jshopping_states` where `country_id` = 176;

insert into `#__jshopping_states` (`country_id`, `state_publish`, `ordering`, `name_en-GB`, `name_de-DE`, `name_ru-RU`)
values ('176', '1', '1', 'respublika Adygeya', 'respublika Adygeya', 'Респ Адыгея'),
       ('176', '1', '2', 'respublika Bashkortostan', 'respublika Bashkortostan', 'Респ Башкортостан'),
       ('176', '1', '3', 'respublika Buryatiya', 'respublika Buryatiya', 'Респ Бурятия'),
       ('176', '1', '4', 'Chihertey region', 'Chihertey region', 'Респ Алтай'),
       ('176', '1', '5', 'respublika Dagestan', 'respublika Dagestan', 'Респ Дагестан'),
       ('176', '1', '6', 'respublika Ingushetiya', 'respublika Ingushetiya', 'Респ Ингушетия'),
       ('176', '1', '7', 'respublika Kabardino-Balkarskaya', 'respublika Kabardino-Balkarskaya', 'Кабардино-Балкарская Респ'),
       ('176', '1', '8', 'respublika Kalmykiya', 'respublika Kalmykiya', 'Респ Калмыкия'),
       ('176', '1', '9', 'respublika Karachaevo-Cherkesskaya', 'respublika Karachaevo-Cherkesskaya', 'Карачаево-Черкесская Респ'),
       ('176', '1', '10', 'respublika Kareliya', 'respublika Kareliya', 'Респ Карелия'),
       ('176', '1', '11', 'respublika Komi', 'respublika Komi', 'Респ Коми'),
       ('176', '1', '12', 'respublika Marii El', 'respublika Marii El', 'Респ Марий Эл'),
       ('176', '1', '13', 'respublika Mordoviya', 'respublika Mordoviya', 'Респ Мордовия'),
       ('176', '1', '14', 'respublika Saha /Yakutiya/', 'respublika Saha /Yakutiya/', 'Респ Саха /Якутия/'),
       ('176', '1', '15', 'respublika Severnaya Osetiya - Alaniya', 'respublika Severnaya Osetiya - Alaniya', 'Респ Северная Осетия - Алания'),
       ('176', '1', '16', 'respublika Tatarstan', 'respublika Tatarstan', 'Респ Татарстан'),
       ('176', '1', '17', 'respublika Tyva', 'respublika Tyva', 'Респ Тыва'),
       ('176', '1', '18', 'respublika Udmurtskaya', 'respublika Udmurtskaya', 'Удмуртская Респ'),
       ('176', '1', '19', 'respublika Hakasiya', 'respublika Hakasiya', 'Респ Хакасия'),
       ('176', '1', '20', 'respublika Chechenskaya', 'respublika Chechenskaya', 'Чеченская Респ'),
       ('176', '1', '21', 'Chuvashiya Chuvashskaya respublika', 'Chuvashiya Chuvashskaya respublika', 'Чувашская республика - Чувашия'),
       ('176', '1', '22', 'Altayskiy region', 'Altayskiy region', 'Алтайский край'),
       ('176', '1', '23', 'krai Krasnodarskii', 'krai Krasnodarskii', 'Краснодарский край'),
       ('176', '1', '24', 'krai Krasnoyarskii', 'krai Krasnoyarskii', 'Красноярский край'),
       ('176', '1', '25', 'Primorskiy region', 'Primorskiy region', 'Приморский край'),
       ('176', '1', '26', 'krai Stavropolskii', 'krai Stavropolskii', 'Ставропольский край'),
       ('176', '1', '27', 'krai Habarovskii', 'krai Habarovskii', 'Хабаровский край'),
       ('176', '1', '28', 'oblast Amurskaya', 'oblast Amurskaya', 'Амурская обл'),
       ('176', '1', '29', 'oblast Arhangelskaya', 'oblast Arhangelskaya', 'Архангельская обл'),
       ('176', '1', '30', 'oblast Astrahanskaya', 'oblast Astrahanskaya', 'Астраханская обл'),
       ('176', '1', '31', 'oblast Belgorodskaya', 'oblast Belgorodskaya', 'Белгородская обл'),
       ('176', '1', '32', 'oblast Bryanskaya', 'oblast Bryanskaya', 'Брянская обл'),
       ('176', '1', '33', 'oblast Vladimirskaya', 'oblast Vladimirskaya', 'Владимирская обл'),
       ('176', '1', '34', 'oblast Volgogradskaya', 'oblast Volgogradskaya', 'Волгоградская обл'),
       ('176', '1', '35', 'oblast Vologodskaya', 'oblast Vologodskaya', 'Вологодская обл'),
       ('176', '1', '36', 'oblast Voronezhskaya', 'oblast Voronezhskaya', 'Воронежская обл'),
       ('176', '1', '37', 'oblast Ivanovskaya', 'oblast Ivanovskaya', 'Ивановская обл'),
       ('176', '1', '38', 'oblast Irkutskaya', 'oblast Irkutskaya', 'Иркутская обл'),
       ('176', '1', '39', 'oblast Kaliningradskaya', 'oblast Kaliningradskaya', 'Калининградская обл'),
       ('176', '1', '40', 'oblast Kaluzhskaya', 'oblast Kaluzhskaya', 'Калужская обл'),
       ('176', '1', '41', 'krai Kamchatskii', 'krai Kamchatskii', 'Камчатский край'),
       ('176', '1', '43', 'oblast Kirovskaya', 'oblast Kirovskaya', 'Кировская обл'),
       ('176', '1', '44', 'oblast Kostromskaya', 'oblast Kostromskaya', 'Костромская обл'),
       ('176', '1', '45', 'oblast Kurganskaya', 'oblast Kurganskaya', 'Курганская обл'),
       ('176', '1', '46', 'oblast Kurskaya', 'oblast Kurskaya', 'Курская обл'),
       ('176', '1', '47', 'oblast Leningradskaya', 'oblast Leningradskaya', 'Ленинградская обл'),
       ('176', '1', '48', 'oblast Lipeckaya', 'oblast Lipeckaya', 'Липецкая обл'),
       ('176', '1', '49', 'oblast Magadanskaya', 'oblast Magadanskaya', 'Магаданская обл'),
       ('176', '1', '50', 'oblast Moskovskaya', 'oblast Moskovskaya', 'Московская обл'),
       ('176', '1', '51', 'oblast Murmanskaya', 'oblast Murmanskaya', 'Мурманская обл'),
       ('176', '1', '52', 'oblast Nizhegorodskaya', 'oblast Nizhegorodskaya', 'Нижегородская обл'),
       ('176', '1', '53', 'oblast Novgorodskaya', 'oblast Novgorodskaya', 'Новгородская обл'),
       ('176', '1', '54', 'oblast Novosibirskaya', 'oblast Novosibirskaya', 'Новосибирская обл'),
       ('176', '1', '55', 'oblast Omskaya', 'oblast Omskaya', 'Омская обл'),
       ('176', '1', '56', 'oblast Orenburgskaya', 'oblast Orenburgskaya', 'Оренбургская обл'),
       ('176', '1', '57', 'oblast Orlovskaya', 'oblast Orlovskaya', 'Орловская обл'),
       ('176', '1', '58', 'oblast Penzenskaya', 'oblast Penzenskaya', 'Пензенская обл'),
       ('176', '1', '59', 'krai Permskii', 'krai Permskii', 'Пермский край'),
       ('176', '1', '60', 'oblast Pskovskaya', 'oblast Pskovskaya', 'Псковская обл'),
       ('176', '1', '61', 'oblast Rostovskaya', 'oblast Rostovskaya', 'Ростовская обл'),
       ('176', '1', '62', 'oblast Ryazanskaya', 'oblast Ryazanskaya', 'Рязанская обл'),
       ('176', '1', '63', 'oblast Samarskaya', 'oblast Samarskaya', 'Самарская обл'),
       ('176', '1', '64', 'oblast Saratovskaya', 'oblast Saratovskaya', 'Саратовская обл'),
       ('176', '1', '65', 'oblast Sahalinskaya', 'oblast Sahalinskaya', 'Сахалинская обл'),
       ('176', '1', '66', 'oblast Sverdlovskaya', 'oblast Sverdlovskaya', 'Свердловская обл'),
       ('176', '1', '67', 'oblast Smolenskaya', 'oblast Smolenskaya', 'Смоленская обл'),
       ('176', '1', '68', 'oblast Tambovskaya', 'oblast Tambovskaya', 'Тамбовская обл'),
       ('176', '1', '69', 'oblast Tverskaya', 'oblast Tverskaya', 'Тверская обл'),
       ('176', '1', '70', 'oblast Tomskaya', 'oblast Tomskaya', 'Томская обл'),
       ('176', '1', '71', 'oblast Tulskaya', 'oblast Tulskaya', 'Тульская обл'),
       ('176', '1', '72', 'oblast Tyumenskaya', 'oblast Tyumenskaya', 'Тюменская обл'),
       ('176', '1', '73', 'oblast Ulyanovskaya', 'oblast Ulyanovskaya', 'Ульяновская обл'),
       ('176', '1', '74', 'oblast Chelyabinskaya', 'oblast Chelyabinskaya', 'Челябинская обл'),
       ('176', '1', '75', 'krai Zabaikalskii', 'krai Zabaikalskii', 'Забайкальский край'),
       ('176', '1', '76', 'oblast Yaroslavskaya', 'oblast Yaroslavskaya', 'Ярославская обл'),
       ('176', '1', '77', 'Moscow city', 'Moscow city', 'г Москва'),
       ('176', '1', '78', 'gorod Sankt-Peterburg', 'gorod Sankt-Peterburg', 'г Санкт-Петербург'),
       ('176', '1', '79', 'avtonomnaya oblast Evreiskaya', 'avtonomnaya oblast Evreiskaya', 'Еврейская Аобл'),
       ('176', '1', '80', 'avtonomnyi okrug Neneckii', 'avtonomnyi okrug Neneckii', 'Ненецкий АО'),
       ('176', '1', '82', 'avtonomnyi okrug Chukotskii', 'avtonomnyi okrug Chukotskii', 'Чукотский АО'),
       ('176', '1', '83', 'avtonomnyi okrug Yamalo-Neneckii', 'avtonomnyi okrug Yamalo-Neneckii', 'Ямало-Ненецкий АО'),
       ('176', '1', '84', 'respublika Krym', 'respublika Krym', 'Респ Крым'),
       ('176', '1', '85', 'Sevastopol city', 'Sevastopol city', 'г Севастополь'),
       ('176', '1', '86', 'Baikonur city', 'Baikonur city', 'г Байконур');
